import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Define colors for clear and not clear status
clear_color = 'green'
not_clear_color = 'red'
hand_empty_color = 'lightgrey'
table_color = 'darkgrey'

# Add table
table = patches.Rectangle((0.05, 0.05), 0.9, 0.1, linewidth=1, edgecolor='black', facecolor=table_color)
ax.add_patch(table)
ax.text(0.5, 0.1, 'Table', horizontalalignment='center', verticalalignment='center', fontsize=10, color='white')

# Define blocks with their positions and statuses
blocks = {
    'block_a': {'pos': (0.1, 0.2), 'color': not_clear_color, 'status': 'supports d'},
    'block_b': {'pos': (0.4, 0.2), 'color': not_clear_color, 'status': 'supports c'},
    'block_c': {'pos': (0.4, 0.3), 'color': clear_color, 'status': 'clear'},
    'block_d': {'pos': (0.1, 0.3), 'color': clear_color, 'status': 'clear'},
    'block_e': {'pos': (0.7, 0.2), 'color': clear_color, 'status': 'clear'},
}

# Create rectangles for blocks
for block, info in blocks.items():
    rect = patches.Rectangle(info['pos'], 0.2, 0.1, linewidth=1, edgecolor='black', facecolor=info['color'])
    ax.add_patch(rect)
    ax.text(info['pos'][0] + 0.1, info['pos'][1] + 0.05, f'{block}\n{info["status"]}', 
            horizontalalignment='center', verticalalignment='center', fontsize=8, color='white')

# Add hand
hand = patches.Ellipse((0.5, 0.6), 0.15, 0.07, linewidth=1, edgecolor='black', facecolor=hand_empty_color)
ax.add_patch(hand)
ax.text(0.5, 0.6, 'Hand\nempty', horizontalalignment='center', verticalalignment='center', fontsize=8, color='black')

# Add legend
legend_patches = [
    patches.Patch(color=clear_color, label='Clear'),
    patches.Patch(color=not_clear_color, label='Not Clear'),
    patches.Patch(color=hand_empty_color, label='Hand Empty')
]
ax.legend(handles=legend_patches, loc='upper right', fontsize=8)

# Set limits and hide axes
ax.set_xlim(0, 1)
ax.set_ylim(0, 0.8)
ax.axis('off')

# Save the figure
plt.savefig('blocksworld/one_shot/ini_diagram_code/attempts/attempt_15.png', bbox_inches='tight')
plt.show()